local assets =
{
	Asset("ANIM", "anim/blstone.zip"),
	Asset("IMAGE", "images/inventoryimages/blackstone.tex"),
	Asset("ATLAS", "images/inventoryimages/blackstone.xml"),
	Asset("IMAGE", "images/inventoryimages/blackstone_r.tex"),
	Asset("ATLAS", "images/inventoryimages/blackstone_r.xml"),
}

local function OnMark(inst, doer)
   if not inst.components.telestone.marked or not inst.components.telestone.markedcave then
   inst.components.inventoryitem.atlasname = "images/inventoryimages/blackstone_r.xml"
   inst.components.inventoryitem:ChangeImageName("blackstone_r")
   inst.AnimState:PlayAnimation("cooked")
   end
end
local function OnRecall(inst, doer)

	if doer:HasTag("player") then
		doer.components.health:SetInvincible(true)
		doer.components.playercontroller:Enable(false)
		
		TheFrontEnd:SetFadeLevel(1)
		doer:DoTaskInTime(4, function() 
			TheFrontEnd:Fade(true,2)
			doer.sg:GoToState("wakeup")
			local var = math.random(1,2)
			if var == 1 then
			   if doer.components.sanity then
				  doer.components.sanity:DoDelta(-30)
			   end
			elseif var == 2 then
			   doer.components.health:SetInvincible(false)
		       if doer.components.health then
			   doer.components.health:DoDelta(-25)
			   doer.components.health:SetInvincible(true)
			   end
			end
		end)
		doer:DoTaskInTime(5, function()
			doer.components.health:SetInvincible(false)
			doer.components.playercontroller:Enable(true)
		end)
	end
   inst.components.inventoryitem.atlasname = "images/inventoryimages/blackstone.xml"
   inst.components.inventoryitem:ChangeImageName("blackstone")
   inst.components.finiteuses:SetConsumption(ACTIONS.RECALL, 1)
   inst.AnimState:PlayAnimation("idle")
end

local function OnReset(inst, doer)
inst.components.inventoryitem.atlasname = "images/inventoryimages/blackstone.xml"
inst.components.inventoryitem:ChangeImageName("blackstone")
inst.AnimState:PlayAnimation("idle")
end

local function onfinished(inst)
    inst:Remove()
end

local function OnLoad(inst, data)
    if inst.components.telestone:IsMarked() and GetSeasonManager():GetSeason() ~= "caves" then
	inst.AnimState:PlayAnimation("cooked")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/blackstone_r.xml"
	inst.components.inventoryitem:ChangeImageName("blackstone_r")
	elseif inst.components.telestone:IsMarkedCave() and GetSeasonManager():GetSeason() == "caves" then
	inst.AnimState:PlayAnimation("cooked")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/blackstone_r.xml"
	inst.components.inventoryitem:ChangeImageName("blackstone_r")
	end
end

local function fn(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)    
   
    inst.AnimState:SetBank("pumpkin")
    inst.AnimState:SetBuild("blstone")
    inst.AnimState:PlayAnimation("idle")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/blackstone.xml"
	
	inst:AddComponent("telestone")
	inst.components.telestone.onMark = OnMark
	inst.components.telestone.onReset = OnReset
	inst.components.telestone.onRecall = OnRecall
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.BLACKSTONE_USES)
    inst.components.finiteuses:SetUses(TUNING.BLACKSTONE_USES)
    inst.components.finiteuses:SetOnFinished(onfinished)
	
	inst:AddComponent("rechargeable")
	inst.components.rechargeable.rechargematerial = "nightmarefuel"
    
    inst.OnLoad = OnLoad
	
    return inst
end

return Prefab( "common/inventory/blackstone", fn, assets)